<?php
/**
 * Template Name: Załoga
 *
 * Template for displaying a page without sidebar even if a sidebar widget is published.
 *
 * @package understrap
 */

get_header();


 $meta_value = get_post_meta($post->ID, 'Długi tytuł');
 $meta_value_2 = get_post_meta($post->ID, 'Tekst za tytułem');
?>

<div class="container-fluid pln prn">

    <!--HEADER!-->

    <div class="col-md-12 pln header" style="overflow:hidden" >

        <?php echo get_the_post_thumbnail( $post->ID ); ?>
        <?php if(get_the_post_thumbnail( $post->ID )): ?>
            <?php echo get_the_post_thumbnail( $post->ID ) ?>
        <?php else: ?>
            <img src="<?php echo get_template_directory_uri().'/img/page-header.jpg' ?>">
        <?php endif; ?>

        <div class="page-title hidden-xs">
            <?php if(!empty($meta_value)): ?>
                <h3 class="gb font42"><?php echo $meta_value[0] ?></h3>
            <?php else: ?>
                <h3 class="gb font42"><?php echo the_title() ?></h3>
            <?php endif ?>
            <?php if(!empty($meta_value_2)): ?>
                <p class="gb font21"><?php echo $meta_value_2[0] ?></p>

            <?php endif ?>

        </div>
    </div>

</div>

<div class="container-fluid breadcrumbs-container bg-grey2 pln prn pbn">
    <div class="container-fluid" style="padding-left:1.2%;">
        <!--BREADCRUMBS!-->
        <div class="container pbn">
            <div class="container pbn">
                <!--BREADCRUMBS!-->
                <?php

                if ( function_exists('yoast_breadcrumb') ) {
                    yoast_breadcrumb('
<p id="breadcrumb mbn">','</p>
');
                }
                ?>
            </div>

        </div>
    </div>
</div>


<!--CREW!-->
<div class="col-md-12 text-center pln prn pt30 pb30">
    <h1 class="h1 separator mt5 pt30 pb30"><span style="background:#fff; padding: 0 15px ;">Meet our crew</span></h1>
</div>
<div class="container pt30">

    <?php
    $args = array(
        'post_type' => 'the_crew'
    );

    $child_query = new WP_Query( $args );
    ?>
    <?php $i=0; ?>
    <?php while ( $child_query->have_posts() ) : $child_query->the_post(); ?>

        <div class="col-lg-4 col-sm-6 gr pt30 pb30 wow fadeIn member mb10" data-wow-delay="350ms" data-wow-duration="750ms">

            <div class="person"><img alt="Surreys Stell meet our crew" class="img-square img-responsive center-block" src="<?php echo the_post_thumbnail_url('crew-img') ?>" /></div>
            <h3 class="gbl blue2"><?php echo the_title() ?></h3>

            <p class="font18"><?php the_content() ?></p>
        </div>

        <?php $i++; ?>
    <?php endwhile; ?>

    <?php
    wp_reset_postdata();
    ?>



</div>


</div>
<!--THE CREW!-->




<?php get_footer(); ?>
