<?php
/**
 * Template Name: Lista produktów
 *
 * Template for displaying a page without sidebar even if a sidebar widget is published.
 *
 * @package understrap
 */

get_header();

$current_category = get_queried_object()->post_title;


?>

<div class="container-fluid bg-grey2 pln prn pbn">
    <div class="container-fluid" style="padding-left:1.2%;">
        <!--BREADCRUMBS!-->



    </div>
</div>

<div class="container-fluid pb30 mb30 bg-content pln prn" id="main-content" style="padding: 1% 2%">
    <div class="col-md-3 col-sm-4 pln hidden-xs pt20">

        <div id="MainMenu gr" class="border-menu mt10">
            <div class="list-group panel">

                <?php
                foreach( get_terms( array( 'taxonomy' => 'product_cat' ) ) as $category ) :
                    $products_loop = new WP_Query( array(
                        'post_type' => 'product',

                        'showposts' => -1,

                        'tax_query' => array_merge( array(
                            'relation'  => 'AND',
                            array(
                                'taxonomy' => 'product_cat',
                                'terms'    => array( $category->term_id ),
                                'field'   => 'term_id'
                            )
                        ), WC()->query->get_tax_query() ),

                        'meta_query' => array_merge( array(

                            // You can optionally add extra meta queries here

                        ), WC()->query->get_meta_query() )
                    ) );

                    ?>

                    <a href="#category<?php echo $category->name ?>" class="list-group-item main-category <?php echo ($current_category==$category->name) ? 'active' : '' ?>"  data-toggle="collapse" data-parent="#MainMenu"><?php echo $category->name; ?> [+]</a>
                    <div class="collapse  <?php echo ($current_category==$category->name) ? 'in' : 'collapsed' ?>  " id="category<?php echo $category->name ?>">

                        <?php
                        while ( $products_loop->have_posts() ) {
                            $products_loop->the_post();
                            /**
                             * woocommerce_shop_loop hook.
                             *
                             * @hooked WC_Structured_Data::generate_product_data() - 10
                             */
                            do_action( 'woocommerce_shop_loop' );
                            ?>
                            <li class="list-group-item "><a href="<?php echo get_permalink() ?>"><?php the_title() ?> </a></li>
                            <?php

                        } ?>

                        <?php /*    @foreach ($menu->children as $child)
                        <a href="{{url($child->url)}}" class="list-group-item">{{$child->name}}</a>
                        @endforeach
                         */
                        ?>
                    </div>

                    <?php
                    wp_reset_postdata();
                endforeach; ?>

                <a class="list-group-item main-category" href="<?php echo get_home_url(); ?>/connection-types/">CONNECTION TYPES </a>
            </div>
        </div>
    </div><!--END MENU-->

    <div class="col-md-9 col-sm-8">

        <div class="col-md-12 text-offer pln">


            <?php



            $args = array(
                'post_type'      => 'product',
                'posts_per_page' => 100000,
            );

            $loop = new WP_Query( $args );

            while ( $loop->have_posts() ) : $loop->the_post();
                global $product;
                ?>

                <a href="<?php echo get_permalink() ?>" class="col-md-3 col-sm-4 col-xs-6 product-thumb pb30">
                        <span class="media-object">
                           <?php echo woocommerce_get_product_thumbnail('small-product') ?>
                        </span>
                    <span class="media-heading text-center gb "><?php echo get_the_title() ?></span>
                </a>



                <?php

            endwhile;

            wp_reset_query();
            ?>



        </div>
    </div>
</div>

<?php get_footer(); ?>
