<?php
/**
 * Template Name: Realizacje
 *
 * Template for displaying a page without sidebar even if a sidebar widget is published.
 *
 * @package understrap
 */

get_header();




?>


<?php
$image_ids = array ();

// get all the galleries in the post
if ( $galleries = get_post_galleries(  $post->ID, false ) ) {

    foreach ( $galleries as $gallery ) {

        // pull the ids from each gallery
        if ( ! empty ( $gallery[ 'ids' ] ) ) {

            // merge into our final list
            $image_ids = array_merge( $image_ids, explode( ',', $gallery[ 'ids' ] ) );
        }
    }
}

// make the values unique
$image_ids = array_unique( $image_ids );

// convert the ids to urls -- $gallery[ 'src' ] already holds this info
$image_urls = array_map( "wp_get_attachment_url", $image_ids );

// ---------------------------- //

?>
<div class="container-fluid">
    <div class="row">
        <div class="col-xs-12">
            <div class="row realizacje_content">
                <?php
                $args = array( 'post_parent' => $post->ID, 'order' => 'ASC');
                $attachments = get_children($args);

                foreach( $image_ids as $image_id) {
                    ?>

                    <div class="effect-ming thumb col-lg-2 col-md-3 col-sm-4 col-xs-6 relative">
                        <div class="realizacje_item">
                            <div class="image-box" >
                                <a data-fancybox="gallery" href="<?php  echo wp_get_attachment_image_url( $image_id, 'portfolio-img-big' ); ?>">
                                    <img src="<?php  echo wp_get_attachment_image_url( $image_id, 'portfolio-img' ); ?>" class="img-responsive">
                                </a>

                            </div>

                        </div>
                    </div>
                    <?php
                }
                ?>
            </div>
        </div>
    </div>
    <div class="col-md-12 pln pb30 text-center">
        <a class="btn-main mt30" href="javascript:window.history.back();"><i class="fa fa-arrow-circle-left pr5"></i>BACK </a>

    </div>
</div>

<?php get_footer(); ?>
