<?php
/**
 * Partial template for content in page.php
 *
 * @package understrap
 */

?>
<?php $meta_value = get_post_meta($post->ID, 'Długi tytuł') ?>
<?php $meta_value_2 = get_post_meta($post->ID, 'Tekst za tytułem') ?>
<article <?php post_class(); ?> id="post-<?php the_ID(); ?>">

    <div class="container-fluid pln prn">

        <!--HEADER!-->

        <div class="col-md-12 pln header" style="overflow:hidden" >

            <?php echo get_the_post_thumbnail( $post->ID ); ?>
            <?php if(get_the_post_thumbnail( $post->ID )): ?>
                <?php echo get_the_post_thumbnail( $post->ID ) ?>
            <?php else: ?>
                <img src="<?php echo get_template_directory_uri().'/img/page-header.jpg' ?>">
            <?php endif; ?>

            <div class="page-title hidden-xs">
                <?php if(!empty($meta_value)): ?>
                    <h3 class="gb font42"><?php echo $meta_value[0] ?></h3>
                    <?php else: ?>
                    <h3 class="gb font42"><?php echo the_title() ?></h3>
                <?php endif ?>
                <?php if(!empty($meta_value_2)): ?>
                    <p class="gb font21"><?php echo $meta_value_2[0] ?></p>

                <?php endif ?>

            </div>
        </div>

    </div>

    <div class="container-fluid breadcrumbs-container bg-grey2 pln prn pbn">
        <div class="container-fluid" style="padding-left:1.2%;">
            <!--BREADCRUMBS!-->
            <div class="container pbn">
                <div class="container pbn">
                    <!--BREADCRUMBS!-->
                    <?php

                    if ( function_exists('yoast_breadcrumb') ) {
                        yoast_breadcrumb('
<p id="breadcrumb mbn">','</p>
');
                    }
                    ?>
                </div>

            </div>
        </div>
    </div>

	<div class="entry-content">

		<?php the_content(); ?>

		<?php
		wp_link_pages( array(
			'before' => '<div class="page-links">' . __( 'Pages:', 'understrap' ),
			'after'  => '</div>',
		) );
		?>

	</div><!-- .entry-content -->

	<footer class="entry-footer">

		<?php edit_post_link( __( 'Edit', 'understrap' ), '<span class="edit-link">', '</span>' ); ?>

	</footer><!-- .entry-footer -->

</article><!-- #post-## -->
