<?php
/**
 * Understrap enqueue scripts
 *
 * @package understrap
 */

if ( ! function_exists( 'understrap_scripts' ) ) {
	/**
	 * Load theme's JavaScript sources.
	 */
	function understrap_scripts() {
		// Get the theme data.
		$the_theme = wp_get_theme();
        wp_enqueue_style( 'all', get_stylesheet_directory_uri() . '/assets/css/all.css', array(), '1.1' , false );
        wp_enqueue_style( 'fancybox3css', get_stylesheet_directory_uri() . '/assets/css/jquery.fancybox.min.css"', array(), '1.1' , false );



        wp_enqueue_script( 'all', get_template_directory_uri() . '/assets/js/all.js', array(), '1.1', false );
        wp_enqueue_script( 'blueimpgallery', get_template_directory_uri() . '/assets/js/jquery.blueimp-gallery.min.js', array(), '1.1', true );
        wp_enqueue_script( 'bootstrap-image', get_template_directory_uri() . '/assets/js/bootstrap-image-gallery.min.js', array(), '1.1', true );
        wp_enqueue_script( 'fancybox3', get_template_directory_uri() . '/assets/js/jquery.fancybox.min.js', array(), '1.1', true );
        wp_enqueue_script( 'cookie', get_template_directory_uri() . '/assets/js/cookieNotice.js', array(), '1.1', true );
		if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
			wp_enqueue_script( 'comment-reply' );
		}
	}
} // endif function_exists( 'understrap_scripts' ).

add_action( 'wp_enqueue_scripts', 'understrap_scripts' );
