<?php
/**
 * Template Name: Full Width Page
 *
 * Template for displaying a page without sidebar even if a sidebar widget is published.
 *
 * @package understrap
 */

get_header();
$container = get_theme_mod( 'understrap_container_type' );
?>

<div class="wrapper" id="full-width-page-wrapper">

    <div class="<?php echo esc_attr( $container ); ?>" id="content">

        <div class="row ">

            <div class="col-md-12 content-area" id="primary">

                <main class="site-main" id="main" role="main">

                    <?php if (is_blog()): ?>

                        <div class="row pt30">
                            <!-- Blog Entries Column -->
                            <div class="col-md-8">
                                <div class="row flex-row">
                                    <?php while ( have_posts() ) : the_post(); ?>

                                        <?php get_template_part( 'loop-templates/content', 'blog' ); ?>

                                        <?php
                                        // If comments are open or we have at least one comment, load up the comment template.
                                        if ( comments_open() || get_comments_number() ) :

                                            comments_template();

                                        endif;
                                        ?>

                                    <?php endwhile; // end of the loop. ?>
                                </div>
                                <div class="text-center"><?php understrap_pagination(); ?></div>

                            </div>
                            <!-- Blog Sidebar Widgets Column -->
                            <div class="col-md-3 affix" id="affix-blog-menu"  >
                                <!-- Blog Categories Well -->
                                <div class="well gr no-border no-round">
                                    <h4>Archive</h4>
                                    <div class="row">
                                        <ul class="list-unstyled col-xs- archive-list">
                                            <?php $args = array(
                                                'type'            => 'monthly',
                                                'limit'           => '',
                                                'format'          => 'html',
                                                'before'          => '',
                                                'after'           => '',
                                                'show_post_count' => false,
                                                'echo'            => 1,
                                                'order'           => 'DESC',
                                                'post_type'     => 'post'
                                            );
                                            wp_get_archives( $args ); ?>
                                        </ul>
                                    </div>
                                    <!-- /.row -->
                                </div>
                                <!-- Side Widget Well -->
                                <div class="well no-border no-round tags">
                                    <h4>Tags</h4>

                                    <p>
                                        <?php
                                        $tags = get_tags();
                                        $html = '';
                                        foreach ( $tags as $tag ) {
                                            if($tag->slug != "migliori"){
                                                $tag_link = get_tag_link( $tag->term_id );
                                                $html .= "<a href='{$tag_link}' class='{$tag->slug}'>";
                                                $html .= "{$tag->name}</a>";

                                            }
                                        }
                                        $html .= '';
                                        echo $html;
                                        ?>
                                    </p>
                                </div>
                            </div>
                        </div>



                    <?php else: ?>
                        <?php while ( have_posts() ) : the_post(); ?>

                            <?php get_template_part( 'loop-templates/content', 'page' ); ?>

                            <?php
                            // If comments are open or we have at least one comment, load up the comment template.
                            if ( comments_open() || get_comments_number() ) :

                                comments_template();

                            endif;
                            ?>

                        <?php endwhile; // end of the loop. ?>

                    <?php endif; ?>




                </main><!-- #main -->

            </div><!-- #primary -->

        </div><!-- .row end -->

    </div><!-- Container end -->

</div><!-- Wrapper end -->


<script type="text/javascript">


    $('document').ready(function () {
        if (screen.width > 950) {
            $("#affix-blog-menu").css({"position": "fixed", "right": "12%", "width": "25%", "padding-right": "30px"});
            $('#affix-blog-menu').affix({
                offset: {
                    top: 100,
                    bottom: 700
//                bottom: function () {
//                    return (this.bottom = $('.bg-newsletter').outerHeight(true))
//                }
                }
            });
        }




        $(window).resize(function () {

            if (screen.width > 950) {
                $("#affix-blog-menu").css({"position": "fixed", "right": "12%", "width": "25%", "left": "auto", "padding-right": "30px"});
                $('#affix-blog-menu').affix({
                    offset: {
                        top: 100,
                        bottom: 700
                    }
                });
            }
            else{
                $('#affix-blog-menu').removeClass('affix');
                $("#affix-blog-menu").css({"position": "relative", "width": "100%", "top": "10px" , "left": "0px"});
            }
        });
    });


</script>
<?php get_footer(); ?>
