<?php
/**
 * The header for our theme.
 *
 * Displays all of the <head> section and everything up till <div id="content">
 *
 * @package understrap
 */

$container = get_theme_mod( 'understrap_container_type' );
?>
<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
	<meta charset="<?php bloginfo( 'charset' ); ?>">
	<meta http-equiv="X-UA-Compatible" content="IE=edge">
	<meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
	<meta name="mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-capable" content="yes">
	<meta name="apple-mobile-web-app-title" content="<?php bloginfo( 'name' ); ?> - <?php bloginfo( 'description' ); ?>">
	<link rel="profile" href="http://gmpg.org/xfn/11">
	<link rel="pingback" href="<?php bloginfo( 'pingback_url' ); ?>">
    <link href="https://fonts.googleapis.com/css?family=Roboto" rel="stylesheet">
	<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<div class="hfeed site" id="page">

    <div class="container-fluid prn pln" style="padding-bottom:0">
        <div class="col-md-12 top-belt text-right pr30">Rainbow Industrial Estate Station Approach Off Grand Drive Raynes Park SW20 0JY</div>
        <div class="col-md-12 prn pln  border-bottom-2">
            <nav class="top-menu navbar" style="margin-bottom:0">
                <div class="container-fluid pt10 pb10">
                    <div class="navbar-header">
                        <button type="button" class="navbar-toggle" data-toggle="offcanvas" data-target="#navbar">
                            <span class="sr-only">Toggle navigation</span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                            <span class="icon-bar"></span>
                        </button>
                        <a class="navbar-brand" href="/"><img src="<?php echo get_template_directory_uri().'/assets/img/logo-top.svg' ?>"></a>
                    </div>

                    <div class="pull-right text-center white hidden-sm hidden-xs pt5">
                        <p class="font16 gb pbn mbn" style="color:#CCC; text-transform:uppercase">free quotation | no obligation</p>
                        <p class="font28 gb blue"><i class="fa fa-mobile blue mr15"></i>020 8947 4722</p>
                    </div>
                    <div id="navbar" class="navbar-offcanvas" data-direction="left">
                        <button type="button" class="hidden-sm hidden-md hidden-lg" data-toggle="offcanvas" data-target="#navbar">
                            &#10005;
                        </button>

                        <?php wp_nav_menu(
                            array(
                                'theme_location'  => 'primary',
                                'container_class' => '',
                                'container_id'    => 'navbarNavDropdown',
                                'menu_class'      => 'nav navbar-nav',
                                'fallback_cb'     => '',
                                'menu_id'         => 'main-menu',
                                'walker'          => new understrap_WP_Bootstrap_Navwalker(),
                            )
                        ); ?>
<!--                        --><?php
//                        wp_nav_menu( array(
//                            'theme_location'	=> 'top',
//                            'depth'				=> 3, // 1 = with dropdowns, 0 = no dropdowns.
//                            'container'			=> 'div',
//                            'container_class'	=> 'navbar-offcanvas',
//                            'container_id'		=> 'navbar',
//                            'menu_class'		=> 'nav navbar-nav ',
//                            'fallback_cb'		=> 'WP_Bootstrap_Navwalker::fallback',
//                            'walker'			=> new WP_Bootstrap_Navwalker()
//                        ) );
//                        ?>
                    </div>

                </div>
            </nav>
        </div>
    </div><!-- END TOP MENU! -->


    <?php /*
	<!-- ******************* The Navbar Area ******************* -->
	<div id="wrapper-navbar" itemscope itemtype="http://schema.org/WebSite">

		<a class="skip-link screen-reader-text sr-only" href="#content"><?php esc_html_e( 'Skip to content', 'understrap' ); ?></a>

		<nav class="navbar navbar-expand-md navbar-dark bg-dark">

		<?php if ( 'container' == $container ) : ?>
			<div class="container" >
		<?php endif; ?>

					<!-- Your site title as branding in the menu -->
					<?php if ( ! has_custom_logo() ) { ?>

						<?php if ( is_front_page() && is_home() ) : ?>

							<h1 class="navbar-brand mb-0"><a rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" itemprop="url"><?php bloginfo( 'name' ); ?></a></h1>

						<?php else : ?>

							<a class="navbar-brand" rel="home" href="<?php echo esc_url( home_url( '/' ) ); ?>" title="<?php echo esc_attr( get_bloginfo( 'name', 'display' ) ); ?>" itemprop="url"><?php bloginfo( 'name' ); ?></a>

						<?php endif; ?>


					<?php } else {
						the_custom_logo();
					} ?><!-- end custom logo -->

				<button class="navbar-toggler" type="button" data-toggle="collapse" data-target="#navbarNavDropdown" aria-controls="navbarNavDropdown" aria-expanded="false" aria-label="Toggle navigation">
					<span class="navbar-toggler-icon"></span>
				</button>

				<!-- The WordPress Menu goes here -->
				<?php wp_nav_menu(
					array(
						'theme_location'  => 'primary',
						'container_class' => 'collapse navbar-collapse',
						'container_id'    => 'navbarNavDropdown',
						'menu_class'      => 'navbar-nav',
						'fallback_cb'     => '',
						'menu_id'         => 'main-menu',
						'walker'          => new understrap_WP_Bootstrap_Navwalker(),
					)
				); ?>
			<?php if ( 'container' == $container ) : ?>
			</div><!-- .container -->
			<?php endif; ?>

		</nav><!-- .site-navigation -->

	</div><!-- #wrapper-navbar end -->
*/?>