<?php
/**
 * Right sidebar check.
 *
 * @package understrap
 */
$object = get_queried_object();
$current_category = '';

if(!is_shop()){
    $current_category = get_the_terms( $object->ID, 'product_cat' )[0]->term_id;
}
$slug = get_post_field( 'post_name', get_post() );


?>

<div class="col-md-3 col-sm-4 pln hidden-xs pt20">

    <div id="MainMenu gr" class="border-menu mt10">
        <div class="list-group panel">

            <?php
            foreach( get_terms( array( 'taxonomy' => 'product_cat' ) ) as $category ) :
                $products_loop = new WP_Query( array(
                    'post_type' => 'product',

                    'showposts' => -1,

                    'tax_query' => array_merge( array(
                        'relation'  => 'AND',
                        array(
                            'taxonomy' => 'product_cat',
                            'terms'    => array( $category->term_id ),
                            'field'   => 'term_id'
                        )
                    ), WC()->query->get_tax_query() ),

                    'meta_query' => array_merge( array(

                        // You can optionally add extra meta queries here

                    ), WC()->query->get_meta_query() )
                ) );

                ?>

                <a href="#category<?php echo $category->term_id ?>" class="list-group-item main-category <?php echo ($current_category==$category->term_id) ? 'active' : '' ?>"  data-toggle="collapse" data-parent="#MainMenu"><?php echo $category->name; ?> [+]</a>
                <div class="collapse  <?php echo ($current_category==$category->term_id) ? 'in' : 'collapsed' ?>  " id="category<?php echo $category->term_id ?>">
                    <?php
                    while ( $products_loop->have_posts() ) {
                        $products_loop->the_post();
                        /**
                         * woocommerce_shop_loop hook.
                         *
                         * @hooked WC_Structured_Data::generate_product_data() - 10
                         */
                        do_action( 'woocommerce_shop_loop' );
                        ?>

                        <li class="list-group-item <?php if($slug == basename(get_permalink()) && Is_product()) echo 'active' ?> "><a href="<?php echo get_permalink() ?>"><?php the_title() ?> </a></li>
                        <?php

                    } ?>

                    <?php /*    @foreach ($menu->children as $child)
                    <a href="{{url($child->url)}}" class="list-group-item">{{$child->name}}</a>
                    @endforeach
                     */
                    ?>
                </div>


                <?php
                wp_reset_postdata();
            endforeach; ?>
            <a class="list-group-item main-category" href="<?php echo get_home_url(); ?>/connection-types/">CONNECTION TYPES </a>

        </div>
    </div>
</div><!--END MENU-->
