(function(w,d){
	"use strict";

	// COOKIES NOTICE;
	var cookieNotice = function(cookieName, cookieTime){
	  var domNotice = d.getElementById("cookie-notice"),
		  setButton = d.getElementById("set-cookie"),
		  setCookie = function(name, value, days){
			var expires;
	
			if(days){
			  var date = new Date();
			  date.setTime(date.getTime()+(days*24*60*60*1000));
			  expires = "; expires="+date.toGMTString();
			}
			else{ expires = ""; }
			d.cookie = name+"="+value+expires+"; path=/";
		  },
		  //removeCookie = function(name){ setCookie(name, "", -1); },
		  hideCookieNotice = function(el){ el.style.display = "none"; };
	
	  if(typeof domNotice === "undefined" || domNotice === null){ return false; }
	  if(d.cookie.indexOf(cookieName) != -1){
		hideCookieNotice(domNotice);
		return false;
	  }
	
	  setButton.onclick = function(event){
		setCookie(cookieName, "true", cookieTime);
		hideCookieNotice(domNotice);
	
		if(event.preventDefault()){ event.preventDefault(); }
		 else{ return false; }
	
	  } // END setButton.onclick();
	
	}; // END cookieNotice();
	
	// USAGE: "COOKIE_NAME", EXPIRE TIME IN DAYS;
	cookieNotice("cookie_notice_accepted", 365);
	
})(window,document)


/* DOM ELEMENTS;
<div id="cookie-notice" class="cookie-notice">
  <div class="cookie-notice-container">
    <p>We use cookies to ensure that we give you the best experience on our website. If you continue to use this site we will assume that you are happy with it.</p>
    <a href="#hide-notification" id="set-cookie" class="btn">Ok</a>
    <a href="/cookies">Read more</a>
  </div>
</div>
*/