@extends('layout')

@section('seo_title')
- @if($page->seo_title){{ $page->seo_title }}@else{{ $page->name }}@endif
@endsection
@section('seo_description')
{!! $page->seo_description !!}
@endsection
@section('seo_keywords')
{!! $page->seo_keywords !!}
@endsection

@section('content')

<!-----------------------------------content                            -->
@if(isset($productShow))
<!-- header product display !--> 
<div class="container-fluid pln bg-products">

    <!--HEADER!-->
    <div class="row">

        <div class="col-md-8 col-sm-12 col-xs-12 nazwa-produktu">
            <div class="product-title">
                <div class="">
                    <h3 class="gr font42 pt30 product">{{$productShow->name}}</h3>
                </div>
            </div>
        </div>    

        <div class="col-md-4 col-sm-12 col-xs-12 mt30 pull-right foto-produktu text-center">
            <a href="{{$productShow->photos()->first()->image('big')}}" rel="lightbox" data-gallery="">  
                <img src="{{$productShow->photos()->first()->image('main')}}" class="img-responsive">
                <span class="btn-mini" style="margin-right:50%"><i class="fa fa-search-plus white"></i></span>
            </a>
             
        </div>
        <div class="clearfix"></div>
        <!--NEXT PREV PRODUCT!-->
        <div class="col-sm-12 col-xs-12 text-center hidden-lg hidden-md bg-form pln prn pt15 pb15 navigation-products">
            @if($previous)
            <div class="col-sm-6 col-xs-6 pb5">
                <a href="{{$previous->url()}}" class="white gb font21" ><img src="/img/arrow-left.svg"> POPRZEDNI </a>
            </div>
            @endif
            @if($next)
            <div class="col-sm-6 col-xs-6 pb5 pull-right">
                <a href="{{$next->url()}}" class="white gb font21" > NASTĘPNY <img src="/img/arrow-right.svg"></a>
            </div>
            @endif
        </div>

    </div><!--HEADER!-->
</div> <!-- header product display !-->

@endif      

<div class="container-fluid bg-grey2 pln prn pbn">
    <div class="container-fluid" style="padding-left:1.2%;">
        <!--BREADCRUMBS!-->

        {!! Breadcrumbs::render('page',$page) !!}

    </div>
</div>

<div class="container-fluid pb30 mb30 bg-content pln prn" id="main-content" style="padding: 1% 2%">
    <div class="col-md-3 col-sm-4 pln hidden-xs pt20">

        <div id="MainMenu gr" class="border-menu mt10">
            <div class="list-group panel">

                @foreach ($root->children as $menu)
                @if($menu->products()->count())
                <a href="#category{!! $menu->id !!}" class="list-group-item main-category @if($page->isSelfOrDescendantOf($menu)) in active @endif"  data-toggle="collapse" data-parent="#MainMenu">{{$menu->name}} [+]</a>
                <div class="collapse @if($page->isSelfOrDescendantOf($menu) || in_array(@$productShow->id,$menu->products()->lists('id') )) in active @endif" id="category{!! $menu->id !!}">
                     @foreach($menu->products()->get() as $product)
                                                <li class="list-group-item {{(@$productShow->id == $product->id? 'active' : '' )}}"><a href="{!! url($product->url()) !!}">{{$product->name}} </a></li>
                                                @endforeach
                <?php /*    @foreach ($menu->children as $child)              
                    <a href="{{url($child->url)}}" class="list-group-item">{{$child->name}}</a>
                    @endforeach
                    */ 
                ?>
                </div>
                @else 
                <a class="list-group-item main-category @if($page->id == $menu->id) in active @endif " href="{{url($menu->url)}}">{{$menu->name}}</a>
                @endif
                @endforeach    

            </div>
        </div> 
    </div><!--END MENU-->

    <div class="col-md-9 col-sm-8">

        @yield('content2')
    </div>
</div>

@endsection

